﻿<%@ Page language="c#" codePage="1200" AutoEventWireup="false" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Samochodowka" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Rozliczenie przejazdów</title>
		<script runat="server">
    void OnContextLoad(Object sender, EventArgs args)
    {
        ReportHeader1.Title =
			string.Format(
                ReportHeader1.Title, 
                param.Pojazd.NrRejestracyjny, 
                param.Rok,
                CaptionAttribute.EnumToString(param.Pojazd.Typ),
                param.Pojazd.Dysponent);

        SubTable roz = SamochodowkaModule.GetInstance(param).RozliczeniaEP.WgData;

        ArrayList rms = new ArrayList();
        for(int i=1; i<13; i++){
            ArrayList arr = new ArrayList();
            YearMonth ym = new YearMonth(param.Rok,i);
            foreach (RozliczenieEP rozEP in new SubTable(roz, ym.ToFromTo()))
            {
                foreach (RozliczenieEPPojazdu rp in rozEP.RozliczeniaPojazdow)
                    if (rp.Pojazd==param.Pojazd)
                        arr.Add(rp);
            }
            rms.Add(new RozliczenieMiesieczne(ym, (RozliczenieEPPojazdu[])arr.ToArray(typeof(RozliczenieEPPojazdu))));
        }
        
        Grid1.DataSource = rms;
    }

    public class RozliczenieMiesieczne
    {
        readonly YearMonth miesiac;
        readonly decimal wartoscPrzejadow = 0m;
        readonly decimal wartoscKosztow = 0m;        
        readonly decimal doRozliczenia = 0m;                
        readonly decimal korektaKosztow = 0m;                        
        
        public RozliczenieMiesieczne(YearMonth miesiac, RozliczenieEPPojazdu[] rozliczenia)
        {
            this.miesiac = miesiac;
            if (rozliczenia == null || rozliczenia.Length == 0)
                return;

            foreach (RozliczenieEPPojazdu rp in rozliczenia)
            {
                wartoscPrzejadow += rp.WartoscPrzejazdow;
                wartoscKosztow += rp.WartoscKosztow;
                doRozliczenia += rp.DoRozliczenia;
                korektaKosztow += rp.KorektaKosztow;                
            }
        }

        public YearMonth Miesiac
        {
            get { return miesiac; }
        }

        public decimal WartoscPrzejazdow
        {
            get { return wartoscPrzejadow; }
        }

        public decimal WartoscKosztow
        {
            get { return wartoscKosztow; }
        }

        public decimal DoRozliczenia
        {
            get { return doRozliczenia; }
        }

        public decimal KorektaKosztow
        {
            get { return korektaKosztow;}
        }        
         
    }        
		
	Params param;
	[Context]    
    public Params Param
    {
        set { param = value; }
    }

    public class Params : ContextBase
    {
        public Params(Context cx)
            : base(cx)
        {
            rok = ((RozliczeniaEP.Params)cx[typeof(RozliczeniaEP.Params)]).Okres.To.Year;
						if (rok == 9999)
							rok = Date.Today.Year;
            okres = new FromTo(new Date(rok, 1, 1), new Date(rok, 12, 31));
        }

        Pojazd pojazd = null;

        [Required]
        [Priority(0)]
        public Pojazd Pojazd
        {
            get { return pojazd; }
            set { pojazd = value; }
        }

        readonly FromTo okres;
        [System.ComponentModel.Browsable(false)]
        public FromTo Okres
        {
            get { return okres;  }
        }

        readonly int rok;
        public int Rok{
            get { return rok;  }
        }
    }        
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="RozliczeniePrzejazdow" method="post" runat="server">
			<P><ea:datacontext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"
					oncontextload="OnContextLoad"></ea:datacontext>
				<cc1:ReportHeader id="ReportHeader1" title="Rozliczenie przejazdów {0} ({1}) | Typ: {2} | Dysponent: {3}"
					runat="server"></cc1:ReportHeader><BR>
				<ea:grid id="Grid1" runat="server" RowTypeName="RozliczenieMiesieczne" ShowPrevAgrSum="InFooter"
					ShowAgrSum="True" ShowPageSum="True">
					<Columns>
						<ea:GridColumn Align="Center" DataMember="Miesiac.Month" Caption="Miesiąc" ID="colMiesiac" Total="Info"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="WartoscPrzejazdow" Total="Sum" Caption="Wartość przejazdów"
							Format="{0:n}" ID="colWP"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="WartoscKosztow" Total="Sum" Caption="Wartość kosztów" Format="{0:n}"
							ID="colWK"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="DoRozliczenia" Total="Sum" Caption="Do rozliczenia" Format="{0:n}"
							ID="colDR"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="KorektaKosztow" Total="Sum" Caption="Korekta kosztów"
							Format="{0:n}" ID="GridColumn1"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<cc1:ReportFooter id="ReportFooter1" runat="server">
					<Subtitles>
						<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					</Subtitles>
				</cc1:ReportFooter></P>
		</form>
	</body>
</HTML>

